/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.event;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.event.Event;
import Krasnodar.rockstarnew.systems.event.EventListener;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class EventManager {
    private final ConcurrentHashMap<Type, CopyOnWriteArrayList<EventListener<?>>> listenerMap = new ConcurrentHashMap();
    private final Map<Class<?>, Field[]> declaredFieldsCache = new HashMap();
    private final Comparator<EventListener<?>> priorityOrder = Comparator.comparingInt(listener -> listener.getPriority()).reversed();
    private final BiConsumer<List<EventListener<?>>, Comparator<EventListener<?>>> sortCallback = List::sort;
    private final Consumer<Throwable> errorHandler = Throwable::printStackTrace;

    public void subscribe(Object subscriber) {
        this.modifyEventListenerState(subscriber, (type, listener) -> {
            this.listenerMap.computeIfAbsent((Type)type, k -> new CopyOnWriteArrayList()).add(listener);
            this.sortCallback.accept((List)this.listenerMap.get(type), this.priorityOrder);
        });
    }

    public void unsubscribe(Object subscriber) {
        this.modifyEventListenerState(subscriber, (type, listener) -> {
            CopyOnWriteArrayList<EventListener<?>> listeners = this.listenerMap.get(type);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.listenerMap.remove(type);
                }
            }
        });
    }

    public <T extends Event> void triggerEvent(T event) {
        Class<?> eventType = event.getClass();
        List listeners = this.listenerMap.get(eventType);
        if (listeners != null && !Rockstar.INSTANCE.isPanic()) {
            for (EventListener listener : listeners) {
                try {
                    listener.onEvent(event);
                }
                catch (Throwable var7) {
                    this.errorHandler.accept(var7);
                }
            }
        }
    }

    private void modifyEventListenerState(Object o, BiConsumer<Type, EventListener<?>> action) {
        for (Field field : this.getCachedDeclaredFields(o.getClass())) {
            EventListener<?> eventListener;
            if (field.getType() != EventListener.class || (eventListener = this.getEventListener(o, field)) == null) continue;
            Type eventType = ((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            action.accept(eventType, eventListener);
        }
    }

    private Field[] getCachedDeclaredFields(Class<?> clazz) {
        return this.declaredFieldsCache.computeIfAbsent(clazz, Class::getDeclaredFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventListener<?> getEventListener(Object o, Field field) {
        Object var5;
        boolean accessible = field.canAccess(o);
        field.setAccessible(true);
        try {
            EventListener eventListener = (EventListener)field.get(o);
            return eventListener;
        }
        catch (IllegalAccessException var9) {
            this.errorHandler.accept(var9);
            var5 = null;
        }
        finally {
            field.setAccessible(accessible);
        }
        return var5;
    }
}

